/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.analysis.dpCommon.SingleNodeResourceAnalysis;
import ibm.nways.analysis.dpCommon.ThresholdAnalysis;
import ibm.nways.nhm.eui.NhmApplet;
import ibm.nways.nhm.eui.SingleNodeAnalysisPanel;
import ibm.nways.nhm.eui.ThresholdAnalyzer;
import ibm.nways.ras.Traces;
import java.awt.ScrollPane;
import java.util.ResourceBundle;

public class SingleNodeAnalysisApplet
extends NhmApplet
implements ThresholdAnalyzer {
    private String groupName;
    private String hostName;
    private DpResourceInstance resInst;
    private ScrollPane p2;
    private ResourceBundle res = ResourceBundle.getBundle("ibm.nways.nhm.eui.AppletResources");
    private static final int COMMA = 44;
    private static final int EQUAL = 61;

    public void init() {
        super.init();
        try {
            Traces.initializeTraces(this);
        }
        catch (Exception exception) {
            System.out.println("Exception occurred in init() of SinglenodeAnalysisApplet");
            exception.printStackTrace();
        }
        this.showStatus(this.res.getString("s_loadingParms"));
        this.groupName = this.getParameter("resource_name");
        String string = this.getParameter("port_num");
        try {
            this.portNumber = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.portNumber = 2099;
        }
        this.createDataRetriever();
        super.getTimeParms();
        String string2 = null;
        String string3 = null;
        this.resInst = new DpResourceInstance();
        try {
            string = this.getParameter("instance");
            int n = string.indexOf(44);
            int n2 = string.indexOf(61);
            while (n2 != -1) {
                string2 = string.substring(0, n2);
                if (n == -1) {
                    string3 = string.substring(n2 + 1);
                    n2 = -1;
                } else {
                    string3 = string.substring(n2 + 1, n);
                    n = string.indexOf(44, n + 1);
                    n2 = string.indexOf(61, n + 1);
                }
                this.resInst.dpAddInstanceDescriptor(string2, string3);
            }
            if (this.resInst.isEmpty()) {
                this.resInst = null;
            }
        }
        catch (Exception exception) {
            Traces.logException(exception);
            exception.printStackTrace();
        }
        this.hostName = this.getParameter("host_name");
        if (this.groupName != null && this.hostName != null) {
            this.p2 = new ScrollPane();
            this.setData();
            this.add("Center", this.p2);
            super.addButtons();
            this.validate();
            return;
        }
        this.showStatus(this.res.getString("s_ParmError"));
    }

    protected void setData() {
        this.showStatus(this.res.getString("s_retrievingData"));
        SingleNodeResourceAnalysis singleNodeResourceAnalysis = this.dataRetriever.retrieveSingleNodeAnalysis(this.hostName, this.groupName, this.resInst, this.startDate, this.endDate);
        if (singleNodeResourceAnalysis != null) {
            SingleNodeAnalysisPanel singleNodeAnalysisPanel = new SingleNodeAnalysisPanel(this, singleNodeResourceAnalysis);
            this.p2.add(singleNodeAnalysisPanel);
            this.showStatus(this.res.getString("s_retrievalComplete"));
            return;
        }
        this.showStatus(this.res.getString("s_retrievalError"));
    }

    public void newTimeRangeSelected() {
        this.p2.removeAll();
        this.setData();
    }

    public ThresholdAnalysis getThresholdAnalysis(String string, String string2) {
        ThresholdAnalysis thresholdAnalysis = null;
        this.showStatus(this.res.getString("s_retrievingData"));
        thresholdAnalysis = this.dataRetriever.retrieveThresholdAnalysis(string, this.hostName, string2, this.startDate, this.endDate);
        if (thresholdAnalysis == null) {
            this.showStatus(this.res.getString("s_NoEvents"));
        } else {
            this.showStatus(this.res.getString("s_retrievalComplete"));
        }
        return thresholdAnalysis;
    }

    public String getTimeRangeString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.df.format(this.startDate));
        stringBuffer.append(" - ");
        stringBuffer.append(this.df.format(this.endDate));
        return stringBuffer.toString();
    }
}

